package com.example.sefinsa_app.ui.folios.crear;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Bundle;
import android.provider.MediaStore;
import android.util.Base64;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;

import com.example.sefinsa_app.R;

import java.io.ByteArrayOutputStream;
import java.util.Objects;
import java.util.UUID;

public class DibujarFirmaActivity extends AppCompatActivity {

    ImageView imgFirma;
    Button btnReiniciarFirma;
    Button btnGuardarFirma;
    TextView txtTitulo;

    private Bitmap bitmap;
    private Canvas canvas;
    private Paint paint = new Paint();

    private float floatStartX = -1, floatStartY = -1, floatEndX = -1, floatEndY = -1;
    private boolean firma = false;

    @SuppressLint("ClickableViewAccessibility")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_dibujar_firma);

        imgFirma = findViewById(R.id.imgFirma);
        btnGuardarFirma = findViewById(R.id.btnGuardarFirma);
        btnReiniciarFirma = findViewById(R.id.btnReiniciarFirma);
        txtTitulo = findViewById(R.id.txtTituloFirma);

        Bundle bundle = getIntent().getExtras();
        String titulo = bundle.getString("titulo");
        txtTitulo.setText(titulo);

        imgFirma.post(() -> {
            int width = imgFirma.getWidth();
            int height = imgFirma.getHeight();
            initCanvas(width, height);
        });

        btnReiniciarFirma.setOnClickListener(v -> {
            firma = false;
            int width = imgFirma.getWidth();
            int height = imgFirma.getHeight();
            initCanvas(width, height);
        });

        btnGuardarFirma.setOnClickListener(v -> {
            if (!firma) {
                new AlertDialog.Builder(DibujarFirmaActivity.this)
                        .setTitle("Dibujar firma")
                        .setMessage("Se tiene que dibujar una firma para poder continuar.")
                        .setPositiveButton("Aceptar", (dialog, id) -> dialog.dismiss())
                        .show();
            } else {
                Bitmap scaledBitmap = Bitmap.createScaledBitmap(bitmap, 300, 200, true);

                Toast.makeText(getApplicationContext(), "Firma guardada", Toast.LENGTH_SHORT).show();

                SharedPreferences p = getSharedPreferences("firmas", Context.MODE_PRIVATE);
                SharedPreferences.Editor e = p.edit();

                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                scaledBitmap.compress(Bitmap.CompressFormat.PNG, 100, baos);
                byte[] bm = baos.toByteArray();
                String imageEncoded = Base64.encodeToString(bm, Base64.DEFAULT);

                if (Objects.equals(titulo, "Dibujar firma del administrador")) {
                    e.putString("firmaUsuario", imageEncoded);
                } else if (Objects.equals(titulo, "Dibujar firma de colocadora")) {
                    e.putString("firmaCliente", imageEncoded);
                } else if (Objects.equals(titulo, "Dibujar firma de cliente")) {
                    e.putString("firmaClienteRMD", imageEncoded);
                } else if (Objects.equals(titulo, "Dibujar firma de asesor")) {
                    e.putString("firmaAsesorRMD", imageEncoded);
                }

                e.apply();
                finish();
            }
        });

        imgFirma.setOnTouchListener((v, event) -> {
            firma = true;

            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    floatStartX = event.getX();
                    floatStartY = event.getY();
                    break;

                case MotionEvent.ACTION_MOVE:
                case MotionEvent.ACTION_UP:
                    floatEndX = event.getX();
                    floatEndY = event.getY();
                    drawLine();
                    floatStartX = floatEndX;
                    floatStartY = floatEndY;
                    break;
            }
            return true;
        });
    }

    private void initCanvas(int width, int height) {
        bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
        canvas = new Canvas(bitmap);
        canvas.drawColor(Color.WHITE);
        paint.setColor(Color.BLACK);
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(8);
        imgFirma.setImageBitmap(bitmap);
    }

    private void drawLine() {
        if (canvas != null) {
            canvas.drawLine(floatStartX, floatStartY, floatEndX, floatEndY, paint);
            imgFirma.setImageBitmap(bitmap);
        }
    }
}
